/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.element.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import xaero.common.IXaeroMinimap;
import xaero.common.minimap.element.render.MinimapElementReader;
import xaero.common.minimap.element.render.MinimapElementRenderProvider;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;

public abstract class MinimapElementRendererHandler {
    private final List<MinimapElementRenderer<?, ?>> renderers;
    protected final int location;

    protected MinimapElementRendererHandler(List<MinimapElementRenderer<?, ?>> renderers, int location) {
        this.renderers = renderers;
        this.location = location;
    }

    public void add(MinimapElementRenderer<?, ?> renderer) {
        this.renderers.add(renderer);
    }

    protected double render(Entity renderEntity, EntityPlayer player, double renderX, double renderY, double renderZ, double ps, double pc, double zoom, boolean cave, float partialTicks, Framebuffer framebuffer, IXaeroMinimap modMain, MinimapRendererHelper helper, FontRenderer font, ScaledResolution scaledRes) {
        double resultDepth = 0.0;
        int elementIndex = 0;
        Collections.sort(this.renderers);
        this.beforeRender();
        int indexLimit = this.getIndexLimit();
        for (int i = 0; i < this.renderers.size(); ++i) {
            MinimapElementRenderer<?, ?> renderer = this.renderers.get(i);
            elementIndex = this.renderForRenderer(renderer, renderEntity, player, renderX, renderY, renderZ, ps, pc, zoom, cave, partialTicks, elementIndex, framebuffer, modMain, helper, font, scaledRes, indexLimit);
            double depthStep = this.getElementIndexDepth(elementIndex, indexLimit);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)depthStep);
            resultDepth += depthStep;
            if ((indexLimit -= elementIndex) >= 0) continue;
            indexLimit = 0;
        }
        this.afterRender();
        return resultDepth;
    }

    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> int renderForRenderer(RR renderer, Entity renderEntity, EntityPlayer player, double renderX, double renderY, double renderZ, double ps, double pc, double zoom, boolean cave, float partialTicks, int elementIndex, Framebuffer framebuffer, IXaeroMinimap modMain, MinimapRendererHelper helper, FontRenderer font, ScaledResolution scaledRes, int indexLimit) {
        MinimapElementReader elementReader = renderer.elementReader;
        MinimapElementRenderProvider provider = renderer.provider;
        Object context = renderer.context;
        int location = this.location;
        if (!renderer.shouldRender(location)) {
            return elementIndex;
        }
        renderer.preRender(location, renderEntity, player, renderX, renderY, renderZ, scaledRes, modMain);
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            double optionalDepth;
            Object element = provider.setupContextAndGetNext(location, context);
            if (element == null || elementReader.isHidden(element, context) || !this.transformAndRenderForRenderer(renderer, font, framebuffer, helper, renderEntity, player, renderX, renderY, renderZ, ps, pc, zoom, cave, partialTicks, elementIndex, optionalDepth = this.getElementIndexDepth(elementIndex, indexLimit), element, elementReader, context, scaledRes)) continue;
            ++elementIndex;
        }
        provider.end(location, context);
        renderer.postRender(location, renderEntity, player, renderX, renderY, renderZ, scaledRes, modMain);
        return elementIndex;
    }

    protected double getElementIndexDepth(int elementIndex, int indexLimit) {
        return (double)(elementIndex >= indexLimit ? indexLimit : elementIndex) * 0.1;
    }

    protected abstract int getIndexLimit();

    protected abstract <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(RR var1, FontRenderer var2, Framebuffer var3, MinimapRendererHelper var4, Entity var5, EntityPlayer var6, double var7, double var9, double var11, double var13, double var15, double var17, boolean var19, float var20, int var21, double var22, E var24, MinimapElementReader<E, RRC> var25, RRC var26, ScaledResolution var27);

    protected abstract void beforeRender();

    protected abstract void afterRender();

    public static abstract class Builder {
        protected Builder() {
        }

        protected Builder setDefault() {
            return this;
        }

        public MinimapElementRendererHandler build() {
            return this.buildInternally(new ArrayList());
        }

        protected abstract MinimapElementRendererHandler buildInternally(List<MinimapElementRenderer<?, ?>> var1);
    }
}

